/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUSelect.cpp
//
//	Description:
//		Utility routines to select objects in Photoshop
//
//	Version history:
//		Version 1.0.0	6/29/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUSelect.h"



//-------------------------------------------------------------------------------
//
//	PIUSelectByName
//
// Given a class and a "string" name. This routine will force focus on that Object.
//
//-------------------------------------------------------------------------------
SPErr PIUSelectByName(DescriptorClassID desiredClass, char *cstrValue)
{
	SPErr error = kSPNoError;
	PIActionReference reference = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionDescriptor result = NULL;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutName(reference,
										desiredClass,
										cstrValue);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&descriptor);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->PutReference(descriptor, 
		                                      keyNull, 
											  reference);
	if (error) goto returnError;
	
	error = sPSActionControl->Play(&result,
								   eventSelect,
								   descriptor, 
								   plugInDialogSilent);
	if (error) goto returnError;
	
	error = PIUCheckPlayResult(result);

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}



//-------------------------------------------------------------------------------
//
//	PIUSelectByIndex
//
// Given a class and an index. This routine will force focus on that Object.
//
//-------------------------------------------------------------------------------
SPErr PIUSelectByIndex(DescriptorClassID desiredClass, uint32 value)
{
	SPErr error = kSPNoError;
	PIActionReference reference = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionDescriptor result = NULL;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutIndex(reference,
										 desiredClass,
										 value);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&descriptor);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->PutReference(descriptor, 
		                                      keyNull, 
											  reference);
	if (error) goto returnError;
	
	error = sPSActionControl->Play(&result,
								   eventSelect,
								   descriptor, 
								   plugInDialogSilent);
	if (error) goto returnError;
	
	error = PIUCheckPlayResult(result);

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}



//-------------------------------------------------------------------------------
//
//	PIUSelectByID
//
// Given a class and an ID. This routine will force focus on that Object.
//
//-------------------------------------------------------------------------------
SPErr PIUSelectByID(DescriptorClassID desiredClass, uint32 value)
{
	SPErr error = kSPNoError;
	PIActionReference reference = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionDescriptor result = NULL;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutIdentifier(reference,
											  desiredClass,
											  value);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&descriptor);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->PutReference(descriptor, 
		                                      keyNull, 
											  reference);
	if (error) goto returnError;
	
	error = sPSActionControl->Play(&result,
								   eventSelect,
								   descriptor, 
								   plugInDialogSilent);
	if (error) goto returnError;
	
	error = PIUCheckPlayResult(result);

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}



//-------------------------------------------------------------------------------
//
//	PIUSelectByOffset
//
// Given a class and an offset. This routine will force focus on that Object.
//
//-------------------------------------------------------------------------------
SPErr PIUSelectByOffset(DescriptorClassID desiredClass, int32 value)
{
	SPErr error = kSPNoError;
	PIActionReference reference = NULL;
	PIActionDescriptor descriptor = NULL;
	PIActionDescriptor result = NULL;

	error = sPSActionReference->Make(&reference);
	if (error) goto returnError;

	error = sPSActionReference->PutOffset(reference,
										  desiredClass,
										  value);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->Make(&descriptor);
	if (error) goto returnError;
	
	error = sPSActionDescriptor->PutReference(descriptor, 
		                                      keyNull, 
											  reference);
	if (error) goto returnError;
	
	error = sPSActionControl->Play(&result,
								   eventSelect,
								   descriptor, 
								   plugInDialogSilent);
	if (error) goto returnError;
	
	error = PIUCheckPlayResult(result);

returnError:
	if (reference != NULL)
		sPSActionReference->Free(reference);
	if (descriptor != NULL)
		sPSActionDescriptor->Free(descriptor);
	if (result != NULL)
		sPSActionDescriptor->Free(result);
	
	return error;
}

// end PIUSelect.cpp
